/* $XFree86: xc/programs/Xserver/hw/xfree86/vga256/drivers/mxic/mxic_driver.h,v 1.1.2.3 1997/06/11 12:08:56 dawes Exp $ */

/* Stephen H.L.Wang
 * 12/29/1997
 * 11/8/1998
 */

/* uncomment this if want to display some debuging message 
 */
/* #define DEBUGTRACE */

/* comment this if want to use programmable clock
 * this symbol, if defined, use a table with 16 predefined clock entries to
 * simulate indexed clock
 */
#define INDEXED_CLOCK

/* uncomment this if want to force to fill all registers for mode setting
 */
/* #define FORCEMODEREG */

/* Header file for MXIC server */

#define PCI_MXIC_VENDOR_ID	0x10D9
#define PCI_MX86250		0x8625
#define PCI_MX86251		0x8626

/* For MX86250 and MX86251, the base addres of COP MMIO linear address is located 
 * at 32MB-128K bytes away from start address of Linear Frame Buffer (LFB)
 */
#define MX8625x_MMIO_REGBASE	0x1FE0000  /* offset 32MB - 128K to LFB */
#define MX8625x_MMIO_REGSIZE	0x20000    /* 128KB */

/* PCI info structure */

typedef struct MXICPCIInformation {
   int DevID;
   int ChipType;
   int ChipRev;
   unsigned long MemBase;
} MXICPCIInformation;

/* Private data structure used for storing all variables needed in driver 
 * This is not exported outside of here, so no need to worry about packing 
 */

typedef enum {MXIC_MX86250, MXIC_MX86251, MXIC_UNKNOWN} ChipID; 

typedef enum { COPSCRWIDTH_640, COPSCRWIDTH_800, COPSCRWIDTH_1024, 
               COPSCRWIDTH_1152, COPSCRWIDTH_1280, COPSCRWIDTH_1600, 
	       COPSCRWIDTH_2048} COPSCRWIDTH;

typedef enum { COPPIXFMT_8BPP, COPPIXFMT_16BPP, COPPIXFMT_15BPP, COPPIXFMT_15BPP0, COPPIXFMT_32BPP, COPPIXFMT_24BPP } COPPIXFMT;

typedef struct {
   ChipID chip;
   unsigned MXIC_MMIO_REGBASE;             /* COP Memory-Mapped I/O offset to LFB */
   unsigned MXIC_MMIO_REGSIZE;             /* COP Memory-Mapped I/O size */
   unsigned MXIC_MEMOFFSCREEN;             /* offscreen memory start offset to LFB */
   COPSCRWIDTH CopScrWidth;
   COPPIXFMT CopPixFmt;
   int HorizScaleFactor;
   int Width, Bpp, Bpl, ScissB;
   unsigned PlaneMask;
   int MCLK;
   Bool NoPCIRetry;
} MXICPRIV;

/* Structure declaration for COP MMIO structure skeleton */

typedef struct {
	unsigned 	COP_MAP_WIDTH;
	unsigned 	COP_LNOFS_SRC_DST;
	unsigned 	COP_SRC_BASEADDR;
	unsigned 	COP_DST_BASEADDR;
	unsigned 	COP_OP_DIM_2;
	unsigned 	COP_COLOR_CMP_MASK;
	unsigned 	COP_CLIP_LEFT_TOP;
	unsigned 	COP_CLIP_RIGHT_BOTTOM;
	unsigned 	COP_COLOR_CMP;
	unsigned 	COP_FG_COLOR;
	unsigned 	COP_BG_COLOR;
	unsigned 	COP_SRC_XY;
	unsigned 	COP_DST_XY;
	unsigned 	COP_OP_DIM_1;
	unsigned 	COP_PIXEL_OP;
	unsigned 	COP_STATUS;
	unsigned char	dummy[0x7F7C];
	unsigned	COP_SCRPORT[0x2000];
} MXIC_MMIO_MEM;

#define COP_SCRPORT_OFS		0x8000

/* Function prototypes */

MXICPCIInformation * mxicGetPCIInfo();
extern Bool MXICCursorInit();
extern void MXICRestoreCursor();
extern void MXICWarpCursor();
extern void MXICQueryBestSize();

extern void MXICAccelInit();
extern void MXICAccelInit24();

/* Global variables declaration */

extern vgaCRIndex, vgaCRReg;
extern unsigned char SystemControlRegIdx;
extern unsigned char BankRegIdx;
extern MXICPRIV mxicPriv;
SymTabRec mxicChipTable[];

#include "mxic_reg.h"
